/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.weka;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Stream;
import ru.ispras.ml.TrainingException;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.datamodel.ListLabelledDataset;
import ru.ispras.ml.prediction.IPredictorTrainer;
import ru.ispras.ml.weka.AbstractWekaPredictorAdapter;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public abstract class AbstractWekaPredictorTrainer<LabelType, A extends AbstractWekaPredictorAdapter>
implements IPredictorTrainer<LabelType> {
    private static final long serialVersionUID = 2998508142018153535L;
    protected Classifier wekaPredictor;
    protected A wekaAdapter;

    public AbstractWekaPredictorTrainer(Classifier wekaPredictor) {
        this.wekaPredictor = wekaPredictor;
    }

    @Override
    public void train(ILabelledInstance<LabelType> precedent) throws TrainingException {
        if (this.wekaAdapter == null) {
            throw new IllegalStateException();
        }
        if (!(this.wekaPredictor instanceof UpdateableClassifier)) {
            throw new UnsupportedOperationException();
        }
        Instance wekaInstance = this.toWekaInstance(precedent, precedent.getLabel(), ((AbstractWekaPredictorAdapter)this.wekaAdapter).getWekaAttributes(), ((AbstractWekaPredictorAdapter)this.wekaAdapter).getOrderedFeatures());
        Instances trainingSet = ((AbstractWekaPredictorAdapter)this.wekaAdapter).getOriginalTrainingSet();
        wekaInstance.setDataset(trainingSet);
        this.updateWekaPredictor(wekaInstance);
        trainingSet.add(wekaInstance);
    }

    public A getWekaAdapter() {
        if (this.wekaAdapter == null) {
            throw new IllegalStateException();
        }
        return this.wekaAdapter;
    }

    protected static List<Feature> uniqueFeatures(IInstance instance) {
        return ImmutableList.copyOf(instance.getFeaturesValues().keySet());
    }

    protected void updateWekaPredictor(Instance wekaInstance) throws TrainingException {
        try {
            ((UpdateableClassifier)this.wekaPredictor).updateClassifier(wekaInstance);
        }
        catch (Exception e) {
            throw new TrainingException(e);
        }
    }

    protected void trainWekaPredictor(Instances trainingSet) throws TrainingException {
        try {
            this.wekaPredictor.buildClassifier(trainingSet);
        }
        catch (Exception e) {
            throw new TrainingException(e);
        }
    }

    protected static FastVector createAttributesForFeatures(List<Feature> uniqueFeatures) {
        FastVector wekaAttributes = new FastVector(uniqueFeatures.size() + 1);
        for (Feature feature : uniqueFeatures) {
            wekaAttributes.addElement((Object)new Attribute(feature.getName()));
        }
        return wekaAttributes;
    }

    protected Instances createWekaDataset(ListLabelledDataset<LabelType> precedents, List<Feature> uniqueFeatures, FastVector wekaAttributes) {
        Instances trainingSet = new Instances("trainingSet", wekaAttributes, (int)precedents.size());
        trainingSet.setClassIndex(wekaAttributes.size() - 1);
        try (Stream stream = (Stream)precedents.stream().sequential();){
            stream.forEach(precedent -> {
                Instance instance = this.toWekaInstance((IInstance)precedent, precedent.getLabel(), wekaAttributes, uniqueFeatures);
                trainingSet.add(instance);
            });
        }
        return trainingSet;
    }

    protected abstract Instance toWekaInstance(IInstance var1, LabelType var2, FastVector var3, List<Feature> var4);
}

