/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.prediction.converted;

import java.util.HashMap;
import java.util.Map;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.Instance;
import ru.ispras.ml.datamodel.value.DoubleValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.ml.prediction.converted.IInstanceConverter;

public final class BiasInstanceConverter
implements IInstanceConverter {
    private static final long serialVersionUID = 3627188802190290793L;
    private static final Feature biasFeature = new Feature("bias", Type.DOUBLE);
    private static final String prefix = "_";
    private final double bias;

    public BiasInstanceConverter(double bias) {
        this.bias = bias;
    }

    @Override
    public IInstance convert(IInstance instance) {
        HashMap<Feature, IValue> featuresValues = new HashMap<Feature, IValue>();
        featuresValues.put(biasFeature, new DoubleValue(this.bias));
        for (Map.Entry<Feature, IValue> featureValue : instance.getFeaturesValues().entrySet()) {
            Feature feature = featureValue.getKey();
            String prefixedFeatureName = prefix + feature.getName();
            featuresValues.put(new Feature(prefixedFeatureName, feature.getType()), featureValue.getValue());
        }
        return new Instance(instance.getId(), featuresValues);
    }
}

