/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.pipelines;

import java.util.function.Supplier;
import java.util.stream.Stream;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.InstanceFactory;
import ru.ispras.ml.datamodel.LabelledInstance;
import ru.ispras.ml.pipelines.PredictionPipeline;
import ru.ispras.ml.pipelines.SourceLabelPair;
import ru.ispras.ml.prediction.IPredictor;
import ru.ispras.ml.prediction.IPredictorTrainer;

public final class PredictionPipelineTrainer<SourceDataType, LabelType> {
    private InstanceFactory<SourceDataType> instanceFactory;
    private IPredictorTrainer<LabelType> predictorTrainer;

    public PredictionPipelineTrainer(InstanceFactory<SourceDataType> instanceFactory, IPredictorTrainer<LabelType> predictorTrainer) {
        this.instanceFactory = instanceFactory;
        this.predictorTrainer = predictorTrainer;
    }

    public PredictionPipeline<SourceDataType, LabelType> train(Supplier<Stream<SourceLabelPair<SourceDataType, LabelType>>> dataset) {
        ILabeledDataset mllibDataset = () -> ((Stream)dataset.get()).map(slPair -> new LabelledInstance(this.instanceFactory.createInstance(slPair.getSource()), slPair.getLabel()));
        this.predictorTrainer.train(mllibDataset);
        IPredictor<LabelType> predictor = this.predictorTrainer.getPredictor();
        return new PredictionPipeline<SourceDataType, LabelType>(this.instanceFactory, predictor);
    }
}

