/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.pipelines;

import java.io.Serializable;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.datamodel.InstanceFactory;
import ru.ispras.ml.datamodel.LabelledInstance;
import ru.ispras.ml.prediction.IPredictor;

public final class PredictionPipeline<SourceDataType, LabelType>
implements Serializable {
    private static final long serialVersionUID = 7083938556999456727L;
    private final InstanceFactory<SourceDataType> instanceFactory;
    private final IPredictor<LabelType> predictor;

    public PredictionPipeline(InstanceFactory<SourceDataType> instanceFactory, IPredictor<LabelType> predictor) {
        this.instanceFactory = instanceFactory;
        this.predictor = predictor;
    }

    public ILabelledInstance<LabelType> apply(SourceDataType source) {
        IInstance instance = this.instanceFactory.createInstance(source);
        return new LabelledInstance<LabelType>(instance, this.predictor.predict(instance).getLabel());
    }
}

