/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.maxent;

import java.util.HashMap;
import java.util.Map;
import ru.ispras.ml.classification.ClassificationException;
import ru.ispras.ml.classification.ConfidenceClassificationResult;
import ru.ispras.ml.classification.IConfidenceClassifier;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.maxent.MaxEntHelper;
import ru.ispras.ml.maxent.MaxEntModel;

public final class MaxEntAdapter<L>
implements IConfidenceClassifier<L> {
    private static final long serialVersionUID = -4645632776106254776L;
    private final MaxEntModel model;
    private final Map<String, L> outcomeToLabel;

    public MaxEntAdapter(MaxEntModel model, Map<String, L> outcomeToLabel) {
        this.model = model;
        this.outcomeToLabel = new HashMap<String, L>(outcomeToLabel);
    }

    @Override
    public ConfidenceClassificationResult<L> predict(IInstance instance) throws ClassificationException {
        MaxEntHelper.MaxEntInstance maxEntInstance = MaxEntHelper.toMaxEntInstance(instance);
        double[] probs = this.model.eval(maxEntInstance.getFeatures(), maxEntInstance.getValues());
        return this.toConfidenceResult(probs);
    }

    private ConfidenceClassificationResult<L> toConfidenceResult(double[] probs) throws ClassificationException {
        int maxIndex = -1;
        double maxValue = Double.NEGATIVE_INFINITY;
        int isZero = 0;
        int isInf = 0;
        int isNaN = 0;
        int nanPosition = -1;
        for (int i = 0; i < probs.length; ++i) {
            double prob = probs[i];
            if (prob > maxValue) {
                maxValue = prob;
                maxIndex = i;
            }
            if (Double.isNaN(prob)) {
                ++isNaN;
                nanPosition = i;
                continue;
            }
            if (Double.isInfinite(prob)) {
                ++isInf;
                continue;
            }
            if (!(Math.abs(prob) < Double.MIN_NORMAL)) continue;
            ++isZero;
        }
        if (isInf > 0 || isNaN > 1 || isNaN == 1 && isZero != probs.length - 1) {
            throw new ClassificationException("");
        }
        if (isNaN == 1) {
            maxValue = 1.0;
            maxIndex = nanPosition;
        }
        L label = this.outcomeToLabel.get(this.model.getOutcome(maxIndex));
        return new ConfidenceClassificationResult<L>(label, maxValue);
    }
}

