/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.liblinear.dense;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ru.ispras.ml.datamodel.Feature;

public class DenseLibLinearClassifierModel<Label>
implements Serializable {
    private static final long serialVersionUID = 5060123306117311368L;
    private final List<Label> labelOrder;
    private final Map<Feature, List<WeightedLabelIndex>> features;
    private final List<WeightedLabelIndex> biases;

    public DenseLibLinearClassifierModel(List<Label> labelOrder, Map<Feature, List<WeightedLabelIndex>> features, List<WeightedLabelIndex> biases) {
        this.labelOrder = labelOrder;
        this.features = features;
        this.biases = biases;
    }

    public List<Label> getLabelsOrder() {
        return this.labelOrder;
    }

    public List<WeightedLabelIndex> getWeightedLabelIndexes(Feature feature) {
        List<WeightedLabelIndex> result = this.features.get(feature);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public List<WeightedLabelIndex> getBiases() {
        return this.biases;
    }

    public static final class WeightedLabelIndex
    implements Serializable {
        private static final long serialVersionUID = -7321179882986430436L;
        private final int labelIndex;
        private final double weight;

        public WeightedLabelIndex(int labelIndex, double weight) {
            this.labelIndex = labelIndex;
            this.weight = weight;
        }

        public int getLabelIndex() {
            return this.labelIndex;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

