/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.liblinear.dense;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import ru.ispras.ml.classification.ClassificationException;
import ru.ispras.ml.classification.ConfidenceClassificationResult;
import ru.ispras.ml.classification.IConfidenceClassifier;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.liblinear.LibLinearFeatureExtractionHelper;
import ru.ispras.ml.liblinear.dense.DenseLibLinearClassifierModel;

public class DenseLibLinearClassifier<Label>
implements IConfidenceClassifier<Label> {
    private static final long serialVersionUID = -345959965814542302L;
    private final DenseLibLinearClassifierModel<Label> model;

    public DenseLibLinearClassifier(DenseLibLinearClassifierModel<Label> model) {
        this.model = model;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfidenceClassificationResult<Label> predict(IInstance instance) throws ClassificationException {
        List<Label> classIds = this.model.getLabelsOrder();
        double[] weights = new double[classIds.size()];
        Arrays.fill(weights, 0.0);
        for (DenseLibLinearClassifierModel.WeightedLabelIndex weightedLabelIndex : this.model.getBiases()) {
            weights[weightedLabelIndex.getLabelIndex()] = weightedLabelIndex.getWeight();
        }
        for (Map.Entry entry : instance.getFeaturesValues().entrySet()) {
            Feature feature = (Feature)entry.getKey();
            double featureValue = LibLinearFeatureExtractionHelper.extractFeatureValue((IValue)entry.getValue());
            List<DenseLibLinearClassifierModel.WeightedLabelIndex> weightedLabelIndexes = this.model.getWeightedLabelIndexes(feature);
            for (DenseLibLinearClassifierModel.WeightedLabelIndex indexWeight : weightedLabelIndexes) {
                int n = indexWeight.getLabelIndex();
                weights[n] = weights[n] + featureValue * indexWeight.getWeight();
            }
        }
        int maxIndex = 0;
        if (classIds.size() == 2) {
            maxIndex = weights[0] > 0.0 ? 0 : 1;
            this.normalize(weights);
        } else {
            void var5_10;
            boolean bl = true;
            while (var5_10 < weights.length) {
                if (weights[var5_10] > weights[maxIndex]) {
                    maxIndex = var5_10;
                }
                ++var5_10;
            }
            this.normalize(weights);
        }
        Label Label = classIds.get(maxIndex);
        double confidence = weights[maxIndex];
        return new ConfidenceClassificationResult<Label>(Label, confidence);
    }

    private void normalize(double[] weights) {
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = 1.0 / (1.0 + Math.exp(-weights[i]));
        }
    }
}

