/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.liblinear.classification;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.FeatureNode;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Model;
import ru.ispras.ml.classification.ConfidenceClassificationResult;
import ru.ispras.ml.classification.IConfidenceClassifier;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.liblinear.LibLinearFeatureExtractionHelper;
import ru.ispras.ml.liblinear.classification.LibLinearClassifier;
import ru.ispras.ml.liblinear.classification.LibLinearClassifierModel;

public class LibLinearConfidenceClassifier<LabelType>
extends LibLinearClassifier<LabelType>
implements IConfidenceClassifier<LabelType> {
    private static final long serialVersionUID = -7449308032337250966L;

    public LibLinearConfidenceClassifier(LibLinearClassifierModel<LabelType> model) {
        super(model);
    }

    @Override
    public ConfidenceClassificationResult<LabelType> predict(IInstance instance) {
        double libLinearLabel;
        FeatureNode[] featureNodes = LibLinearFeatureExtractionHelper.extractLibLinearFeatures(instance, ((LibLinearClassifierModel)this.model).getFeaturesOrder());
        double[] confidences = new double[((LibLinearClassifierModel)this.model).getModel().getNrClass()];
        if (((LibLinearClassifierModel)this.model).getModel().isProbabilityModel()) {
            libLinearLabel = Linear.predictProbability((Model)((LibLinearClassifierModel)this.model).getModel(), (Feature[])featureNodes, (double[])confidences);
        } else {
            libLinearLabel = Linear.predictValues((Model)((LibLinearClassifierModel)this.model).getModel(), (Feature[])featureNodes, (double[])confidences);
            if (((LibLinearClassifierModel)this.model).getModel().getNrClass() == 2) {
                confidences[1] = -confidences[0];
            }
            this.normalize(confidences);
        }
        double confidence = this.maxValue(confidences);
        int classIndex = (int)Math.round(libLinearLabel);
        return new ConfidenceClassificationResult(((LibLinearClassifierModel)this.model).getIndicesToClasses().get(classIndex), confidence);
    }

    private void normalize(double[] confidences) {
        for (int i = 0; i < confidences.length; ++i) {
            confidences[i] = 1.0 / (1.0 + Math.exp(-confidences[i]));
        }
    }

    private double maxValue(double[] confidences) {
        double result = Double.MIN_VALUE;
        double[] dArray = confidences;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double prob = dArray[i];
            result = Math.max(result, prob);
        }
        return result;
    }
}

