/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.featureselectors;

import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.cast.IValueToDouble;
import ru.ispras.ml.featureselectors.IFeatureSelector;

public final class NonAlmostZeroFeatureSelector<LabelType>
implements IFeatureSelector<LabelType> {
    private final int minFeatureValues;

    public NonAlmostZeroFeatureSelector(int minFeatureValues) {
        this.minFeatureValues = minFeatureValues;
    }

    @Override
    public Set<Feature> select(ILabeledDataset<LabelType> dataset) {
        try (Stream stream = dataset.stream();){
            Set<Feature> set = stream.flatMap(instance -> this.extractNonAlmostZeroFeatures((IInstance)instance)).collect(Collectors.groupingBy(UnaryOperator.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() >= (long)this.minFeatureValues).map(entry -> (Feature)entry.getKey()).collect(Collectors.toSet());
            return set;
        }
    }

    private Stream<Feature> extractNonAlmostZeroFeatures(IInstance instance) {
        return instance.getFeaturesValues().entrySet().stream().filter(entry -> Math.abs(IValueToDouble.valueToDouble((IValue)entry.getValue())) >= 9.9E-324).map(entry -> (Feature)entry.getKey());
    }
}

