/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.featureselectors;

import java.util.Set;
import ru.ispras.ml.TrainingException;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.featureselectors.IFeatureSelector;
import ru.ispras.ml.prediction.IPredictor;
import ru.ispras.ml.prediction.IPredictorTrainer;
import ru.ispras.ml.projectors.DatasetProjector;

public final class FeatureSelectingPredictorTrainer<LabelType>
implements IPredictorTrainer<LabelType> {
    private static final long serialVersionUID = 5393234895307447950L;
    private final IFeatureSelector<LabelType> featureSelector;
    private final IPredictorTrainer<LabelType> trainer;

    public FeatureSelectingPredictorTrainer(IFeatureSelector<LabelType> featureSelector, IPredictorTrainer<LabelType> trainer) {
        this.featureSelector = featureSelector;
        this.trainer = trainer;
    }

    @Override
    public void train(ILabelledInstance<LabelType> precedent) throws TrainingException {
        throw new UnsupportedOperationException("On-the-fly learning is not supported.");
    }

    @Override
    public void train(ILabeledDataset<LabelType> data) throws TrainingException {
        Set<Feature> selectedFeatures2 = this.featureSelector.select(data);
        this.trainer.train(new DatasetProjector(selectedFeatures2).project(data));
    }

    @Override
    public IPredictor<LabelType> getPredictor() {
        return this.trainer.getPredictor();
    }
}

