/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.datamodel.value.cast;

import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.StringValue;
import ru.ispras.ml.datamodel.value.cast.ValueCastException;

public class StringValueCaster {
    public static StringValue cast(IValue value) {
        if (value.hasString()) {
            return new StringValue(value.getString());
        }
        if (value.hasBoolean()) {
            return StringValueCaster.cast(value.getBoolean());
        }
        if (value.hasInt()) {
            return StringValueCaster.cast(value.getInt());
        }
        if (value.hasDouble()) {
            return StringValueCaster.cast(value.getDouble());
        }
        throw new ValueCastException();
    }

    public static StringValue cast(boolean value) {
        return new StringValue(Boolean.toString(value));
    }

    public static StringValue cast(double value) {
        return new StringValue(Double.toString(value));
    }

    public static StringValue cast(int value) {
        return new StringValue(Integer.toString(value));
    }

    public static boolean canCast(IValue value) {
        return value.hasString() || value.hasBoolean() || value.hasDouble() || value.hasInt();
    }
}

