/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.datamodel.value.cast;

import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.IntValue;
import ru.ispras.ml.datamodel.value.cast.ValueCastException;

public class IntValueCaster {
    public static IntValue cast(IValue value) {
        if (IntValueCaster.isStringRepresentation(value)) {
            return IntValueCaster.cast(value.getString());
        }
        if (value.hasInt()) {
            return IntValueCaster.cast(value.getInt());
        }
        if (value.hasDouble()) {
            return IntValueCaster.cast(value.getDouble());
        }
        throw new ValueCastException();
    }

    public static boolean canCast(IValue value) {
        return IntValueCaster.isStringRepresentation(value) || IntValueCaster.isDoubleRepresentation(value) || value.hasInt();
    }

    public static IntValue cast(String string) {
        try {
            return IntValueCaster.cast(Integer.parseInt(string));
        }
        catch (NumberFormatException e) {
            throw new ValueCastException(e);
        }
    }

    public static boolean canCast(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static IntValue cast(double value) {
        if (IntValueCaster.canCast(value)) {
            return IntValueCaster.cast((int)Math.round(value));
        }
        throw new ValueCastException();
    }

    public static boolean canCast(double doubleValue) {
        return (double)Math.round(doubleValue) == doubleValue;
    }

    public static IntValue cast(int value) {
        return new IntValue(value);
    }

    private static boolean isDoubleRepresentation(IValue value) {
        if (value.hasDouble()) {
            return IntValueCaster.canCast(value.getDouble());
        }
        return false;
    }

    private static boolean isStringRepresentation(IValue value) {
        if (value.hasString()) {
            return IntValueCaster.canCast(value.getString());
        }
        return false;
    }
}

