/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.datamodel.value.cast;

import ru.ispras.ml.datamodel.value.DoubleValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.cast.ValueCastException;

public class DoubleValueCaster {
    public static DoubleValue cast(IValue value) {
        if (DoubleValueCaster.isStringRepresentation(value)) {
            return DoubleValueCaster.cast(value.getString());
        }
        if (value.hasInt()) {
            return DoubleValueCaster.cast(value.getInt());
        }
        if (value.hasDouble()) {
            return DoubleValueCaster.cast(value.getDouble());
        }
        throw new ValueCastException();
    }

    public static boolean canCast(IValue value) {
        return DoubleValueCaster.isStringRepresentation(value) || value.hasDouble() || value.hasInt();
    }

    public static DoubleValue cast(String string) {
        try {
            return DoubleValueCaster.cast(Double.parseDouble(string));
        }
        catch (NumberFormatException e) {
            throw new ValueCastException(e);
        }
    }

    public static boolean canCast(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static DoubleValue cast(double value) {
        return new DoubleValue(value);
    }

    public static DoubleValue cast(int value) {
        return new DoubleValue(value);
    }

    private static boolean isStringRepresentation(IValue value) {
        return value.hasString() && DoubleValueCaster.canCast(value.getString());
    }
}

