/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.datamodel.value;

import ru.ispras.ml.datamodel.value.AbstractValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.Type;

public class BooleanValue
extends AbstractValue {
    private static final long serialVersionUID = 2263877095322774496L;
    public static final BooleanValue FALSE = new BooleanValue(false);
    public static final BooleanValue TRUE = new BooleanValue(true);
    private boolean data;

    public static BooleanValue of(boolean data) {
        return data ? TRUE : FALSE;
    }

    private BooleanValue(boolean data) {
        this.data = data;
    }

    @Override
    public boolean hasBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.data;
    }

    public String toString() {
        return Boolean.toString(this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IValue && ((IValue)obj).hasBoolean()) {
            return ((IValue)obj).getBoolean() == this.data;
        }
        return false;
    }

    public int hashCode() {
        return this.getBoolean() ? 1231 : 1237;
    }

    @Override
    public Type getFeatureType() {
        return Type.BOOLEAN;
    }
}

