/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.datamodel;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import ru.ispras.ml.datamodel.AbstractInstance;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.identification.IInstanceId;
import ru.ispras.ml.datamodel.value.IValue;

public class Instance
extends AbstractInstance {
    private static final long serialVersionUID = -5770815451286272730L;
    private final Map<Feature, IValue> feature2value;

    public Instance(IInstanceId id, Map<Feature, IValue> feature2value) {
        super(id);
        this.feature2value = ImmutableMap.copyOf(feature2value);
    }

    public Instance(IInstanceId id, Feature feature, IValue value) {
        super(id);
        this.feature2value = ImmutableMap.of((Object)feature, (Object)value);
    }

    @Override
    public IValue getFeatureValue(Feature feature) {
        return this.feature2value.get(feature);
    }

    @Override
    public Map<Feature, IValue> getFeaturesValues() {
        return this.feature2value;
    }

    @Override
    public boolean hasFeature(Feature feature) {
        return this.feature2value.containsKey(feature);
    }

    public String toString() {
        return "Instance[id=" + this.getId().getStringId() + ", " + this.feature2value.toString() + "]";
    }
}

