/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.datamodel;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;

@FunctionalInterface
public interface IDataset<I extends IInstance> {
    default public Set<Feature> getFeatureSet() {
        try (Stream<I> stream = this.stream();){
            Set<Feature> set = stream.flatMap(instance -> instance.getFeaturesValues().keySet().stream()).collect(Collectors.toSet());
            return set;
        }
    }

    default public long size() {
        try (Stream<I> stream = this.stream();){
            long l = stream.count();
            return l;
        }
    }

    default public boolean isEmpty() {
        try (Stream<I> stream = this.stream();){
            boolean bl = !stream.findAny().isPresent();
            return bl;
        }
    }

    public Stream<I> stream();
}

