/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.passiveaggressive.models;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.Validate;
import ru.ispras.ml.classification.passiveaggressive.kernels.IKernelFunction;
import ru.ispras.ml.classification.passiveaggressive.models.AbstractBinaryClassificationModel;
import ru.ispras.ml.classification.passiveaggressive.models.IPAModel;
import ru.ispras.ml.datamodel.IInstance;

public class SupportVectorPAModel<LabelType>
extends AbstractBinaryClassificationModel<LabelType>
implements IPAModel<LabelType> {
    private static final long serialVersionUID = 8713056269687288705L;
    private final List<SupportVector> supportVectors;
    private final IKernelFunction kernel;

    public SupportVectorPAModel(LabelType positiveLabel, LabelType negativeLabel, IKernelFunction kernel) {
        this(positiveLabel, negativeLabel, kernel, new LinkedList<SupportVector>());
    }

    protected SupportVectorPAModel(LabelType positiveLabel, LabelType negativeLabel, IKernelFunction kernel, List<SupportVector> supportVectors) {
        super(positiveLabel, negativeLabel);
        this.kernel = kernel;
        this.supportVectors = supportVectors;
    }

    public List<SupportVector> getSupportVectors() {
        return Collections.unmodifiableList(this.supportVectors);
    }

    @Override
    public IKernelFunction getKernel() {
        return this.kernel;
    }

    @Override
    public double getMarginOn(IInstance instance) {
        Validate.notNull((Object)instance, (String)"Instance should not be null");
        double res = 0.0;
        for (SupportVector sv : this.supportVectors) {
            res += sv.getWeight() * this.kernel.innerProduct(sv.getInstance(), instance);
        }
        return res;
    }

    @Override
    public void add(IInstance instance, double weight) {
        Validate.notNull((Object)instance, (String)"Instance should not be null");
        this.supportVectors.add(new SupportVector(instance, weight));
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        SupportVectorPAModel otherModel = (SupportVectorPAModel)other;
        return this.kernel.equals(otherModel.kernel) && this.supportVectors.equals(otherModel.supportVectors);
    }

    @Override
    public int hashCode() {
        return this.kernel.hashCode() ^ this.supportVectors.hashCode();
    }

    public static class SupportVector
    implements Serializable {
        private static final long serialVersionUID = -3233575446478776220L;
        private final IInstance instance;
        private final double weight;

        SupportVector(IInstance instance, double weight) {
            Validate.notNull((Object)instance, (String)"Instance should not be null");
            this.instance = instance;
            this.weight = weight;
        }

        public IInstance getInstance() {
            return this.instance;
        }

        public double getWeight() {
            return this.weight;
        }

        public boolean equals(Object other) {
            if (other instanceof SupportVector) {
                SupportVector otherSV = (SupportVector)other;
                return this.instance.equals(otherSV.instance) && this.weight == otherSV.weight;
            }
            return false;
        }

        public int hashCode() {
            return this.instance.hashCode() ^ new Double(this.weight).hashCode();
        }
    }
}

