/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.passiveaggressive.models;

import java.io.Serializable;
import org.apache.commons.lang.Validate;

public abstract class AbstractBinaryClassificationModel<LabelType>
implements Serializable {
    private static final long serialVersionUID = 8508965932212447211L;
    private LabelType positiveLabel;
    private LabelType negativeLabel;

    protected AbstractBinaryClassificationModel(LabelType positiveLabel, LabelType negativeLabel) {
        Validate.notNull(positiveLabel, (String)"Positive class label should not be null");
        Validate.notNull(negativeLabel, (String)"Negative class label should not be null");
        this.positiveLabel = positiveLabel;
        this.negativeLabel = negativeLabel;
    }

    public LabelType getPositiveLabel() {
        return this.positiveLabel;
    }

    public LabelType getNegativeLabel() {
        return this.negativeLabel;
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AbstractBinaryClassificationModel otherModel = (AbstractBinaryClassificationModel)other;
        return this.positiveLabel.equals(otherModel.positiveLabel) && this.negativeLabel.equals(otherModel.negativeLabel);
    }

    public int hashCode() {
        return this.positiveLabel.hashCode() ^ this.negativeLabel.hashCode();
    }
}

