/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.passiveaggressive.kernels;

import org.apache.commons.lang.Validate;
import ru.ispras.ml.classification.passiveaggressive.kernels.AbstractKernel;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.value.DoubleValue;
import ru.ispras.ml.datamodel.value.cast.DoubleValueCaster;

public class LinearKernel
extends AbstractKernel {
    private static final long serialVersionUID = -571286261564606711L;
    private static final double DEFAULT_BIAS = 0.0;
    private final double bias;

    public LinearKernel() {
        this.bias = 0.0;
    }

    public LinearKernel(double bias) {
        Validate.isTrue((bias >= 0.0 ? 1 : 0) != 0, (String)"Bias parameter should be greater or equal 0");
        this.bias = bias;
    }

    @Override
    public double innerProduct(IInstance x, IInstance y) {
        double res = this.bias;
        for (Feature feature : x.getFeaturesValues().keySet()) {
            if (!y.hasFeature(feature)) continue;
            DoubleValue xv = DoubleValueCaster.cast(x.getFeatureValue(feature));
            DoubleValue yv = DoubleValueCaster.cast(y.getFeatureValue(feature));
            res += DoubleValueCaster.cast(xv).getDouble() * DoubleValueCaster.cast(yv).getDouble();
        }
        return res;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return this.bias == ((LinearKernel)other).bias;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ new Double(this.bias).hashCode();
    }
}

