/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.passiveaggressive;

import ru.ispras.ml.TrainingException;
import ru.ispras.ml.classification.ClassificationAlgorithmFacade;
import ru.ispras.ml.classification.ClassificationException;
import ru.ispras.ml.classification.ClassificationResult;
import ru.ispras.ml.classification.IClassifier;
import ru.ispras.ml.classification.passiveaggressive.PAClassifier;
import ru.ispras.ml.classification.passiveaggressive.trainers.AbstractPATrainer;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;

public class PassiveAggressive<LabelType>
implements ClassificationAlgorithmFacade<LabelType> {
    private static final long serialVersionUID = -8966451980277675211L;
    private PAClassifier<LabelType> classifier;
    private final AbstractPATrainer<LabelType> trainer;

    public PassiveAggressive(AbstractPATrainer<LabelType> trainer) {
        this.trainer = trainer;
        this.classifier = new PAClassifier<LabelType>(trainer.getModel());
    }

    public PassiveAggressive(AbstractPATrainer<LabelType> trainer, double classifierMargin) {
        this.trainer = trainer;
        this.classifier = new PAClassifier<LabelType>(trainer.getModel(), classifierMargin);
    }

    @Override
    public ClassificationResult<LabelType> predict(IInstance instance) throws ClassificationException {
        return this.classifier.predict(instance);
    }

    @Override
    public void train(ILabelledInstance<LabelType> precedent) throws TrainingException {
        this.trainer.train(precedent);
    }

    @Override
    public void train(ILabeledDataset<LabelType> precedents) throws TrainingException {
        this.trainer.train(precedents);
    }

    @Override
    public IClassifier<LabelType> getPredictor() {
        return this.classifier;
    }
}

