/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.naivebayes;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.value.IValue;

public class NaiveBayesModel<LabelType>
implements Serializable {
    private static final long serialVersionUID = -4478254864815237806L;
    private static final FeatureStatistics emptyFeatureStatistics = new FeatureStatistics();
    private static final ClassStatistics emptyClassStatistics = new ClassStatistics();
    private int numberOfInstances = 0;
    private final Map<LabelType, ClassStatistics> classStatistics = new HashMap<LabelType, ClassStatistics>();

    public void addClassifiedInstance(IInstance instance, LabelType classId) {
        ClassStatistics statistics;
        if (this.classStatistics.containsKey(classId)) {
            statistics = this.classStatistics.get(classId);
        } else {
            statistics = new ClassStatistics();
            this.classStatistics.put(classId, statistics);
        }
        statistics.add(instance);
        ++this.numberOfInstances;
    }

    public Collection<LabelType> getClasses() {
        return this.classStatistics.keySet();
    }

    public ClassStatistics getClassStatistics(LabelType classResult) {
        if (this.classStatistics.containsKey(classResult)) {
            return this.classStatistics.get(classResult);
        }
        return emptyClassStatistics;
    }

    public int getNumberOfClasses() {
        return this.classStatistics.size();
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NaiveBayesModel)) {
            return false;
        }
        NaiveBayesModel other = (NaiveBayesModel)obj;
        return this.numberOfInstances == other.numberOfInstances && this.classStatistics.equals(other.classStatistics);
    }

    public int hashCode() {
        return this.numberOfInstances ^ this.classStatistics.hashCode();
    }

    static class ClassStatistics
    implements Serializable {
        private static final long serialVersionUID = 2885099422128268619L;
        private int numberOfInstancesInClass = 0;
        private Map<Feature, FeatureStatistics> featureStatistics = new HashMap<Feature, FeatureStatistics>();

        public void add(IInstance instance) {
            ++this.numberOfInstancesInClass;
            for (Map.Entry<Feature, IValue> featureValue : instance.getFeaturesValues().entrySet()) {
                FeatureStatistics statistics;
                Feature feature = featureValue.getKey();
                if (this.featureStatistics.containsKey(feature)) {
                    statistics = this.featureStatistics.get(feature);
                } else {
                    statistics = new FeatureStatistics();
                    this.featureStatistics.put(feature, statistics);
                }
                statistics.add(featureValue.getValue());
            }
        }

        public int getNumberOfInstancesInClass() {
            return this.numberOfInstancesInClass;
        }

        public FeatureStatistics getFeatureStatistics(Feature feature) {
            if (this.featureStatistics.containsKey(feature)) {
                return this.featureStatistics.get(feature);
            }
            return emptyFeatureStatistics;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassStatistics)) {
                return false;
            }
            return this.featureStatistics.equals(((ClassStatistics)obj).featureStatistics) && this.numberOfInstancesInClass == ((ClassStatistics)obj).numberOfInstancesInClass;
        }

        public int hashCode() {
            return this.featureStatistics.hashCode();
        }
    }

    static class FeatureStatistics
    implements Serializable {
        private static final long serialVersionUID = 4849695441791073595L;
        private int numberOfInstancesWithFeature = 0;
        private TObjectIntMap<IValue> value2count = new TObjectIntHashMap();

        public void add(IValue value) {
            ++this.numberOfInstancesWithFeature;
            this.value2count.adjustOrPutValue((Object)value, 1, 1);
        }

        public int getCountForValue(IValue value) {
            if (this.value2count.containsKey((Object)value)) {
                return this.value2count.get((Object)value);
            }
            return 0;
        }

        public int getNumberOfInstancesWithFeature() {
            return this.numberOfInstancesWithFeature;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FeatureStatistics)) {
                return false;
            }
            return this.value2count.equals(((FeatureStatistics)obj).value2count) && this.numberOfInstancesWithFeature == ((FeatureStatistics)obj).numberOfInstancesWithFeature;
        }

        public int hashCode() {
            return this.value2count.hashCode();
        }
    }
}

