/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.naivebayes;

import ru.ispras.ml.TrainingException;
import ru.ispras.ml.classification.ClassificationAlgorithmFacade;
import ru.ispras.ml.classification.ClassificationException;
import ru.ispras.ml.classification.ClassificationResult;
import ru.ispras.ml.classification.IClassifier;
import ru.ispras.ml.classification.naivebayes.NaiveBayesClassifier;
import ru.ispras.ml.classification.naivebayes.NaiveBayesTrainer;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;

public class NaiveBayes<LabelType>
implements ClassificationAlgorithmFacade<LabelType> {
    private static final long serialVersionUID = 4735162634019236873L;
    private final NaiveBayesClassifier<LabelType> classifier;
    private final NaiveBayesTrainer<LabelType> trainer = new NaiveBayesTrainer();

    public NaiveBayes() {
        this.classifier = new NaiveBayesClassifier<LabelType>(this.trainer.getModel());
    }

    public NaiveBayes(double smooth) {
        this.classifier = new NaiveBayesClassifier<LabelType>(this.trainer.getModel(), smooth);
    }

    @Override
    public ClassificationResult<LabelType> predict(IInstance instance) throws ClassificationException {
        return this.classifier.predict(instance);
    }

    @Override
    public void train(ILabelledInstance<LabelType> instance) throws TrainingException {
        this.trainer.train(instance);
    }

    @Override
    public void train(ILabeledDataset<LabelType> dataset) throws TrainingException {
        this.trainer.train(dataset);
    }

    @Override
    public IClassifier<LabelType> getPredictor() {
        return this.trainer.getPredictor();
    }
}

