/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.meta;

import java.util.List;
import ru.ispras.ml.classification.ClassificationException;
import ru.ispras.ml.classification.IClassifier;
import ru.ispras.ml.classification.meta.ClassifiedInstances;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.prediction.PredictionResult;

public class ByClassifierErrorsPartitioning<LabelType> {
    private final ClassifiedInstances<LabelType> correctlyClassified;
    private final ClassifiedInstances<LabelType> incorrectlyClassified;

    public ByClassifierErrorsPartitioning(IClassifier<LabelType> classifier, ClassifiedInstances<LabelType> testSet) {
        List<IInstance> instances = testSet.getInstances();
        List<LabelType> classes = testSet.getClassificationResults();
        this.correctlyClassified = new ClassifiedInstances();
        this.incorrectlyClassified = new ClassifiedInstances();
        for (int i = 0; i < instances.size(); ++i) {
            LabelType expected;
            IInstance instance = instances.get(i);
            if (this.isClassifierPredictionCorrect(classifier, instance, expected = classes.get(i))) {
                this.correctlyClassified.add(instance, expected);
                continue;
            }
            this.incorrectlyClassified.add(instance, expected);
        }
    }

    private boolean isClassifierPredictionCorrect(IClassifier<LabelType> classifier, IInstance instance, LabelType expected) {
        try {
            PredictionResult result = classifier.predict(instance);
            return expected.equals(result.getLabel());
        }
        catch (ClassificationException ignore) {
            return false;
        }
    }

    public ClassifiedInstances<LabelType> getCorrectlyClassified() {
        return this.correctlyClassified;
    }

    public ClassifiedInstances<LabelType> getIncorrectlyClassified() {
        return this.incorrectlyClassified;
    }
}

