/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.decisiontrees.id3;

import java.util.Map;
import ru.ispras.ml.classification.decisiontrees.EntropyCounter;
import ru.ispras.ml.classification.decisiontrees.Sample;
import ru.ispras.ml.classification.decisiontrees.SplitSample;
import ru.ispras.ml.datamodel.value.IValue;

public class InformationGainMetricCounter {
    public static <LabelType> double countGain(SplitSample<LabelType> splitSample, int sampleSize, double fullEntropy) {
        double conditionalEntropy = 0.0;
        for (Map.Entry<IValue, Sample<LabelType>> entry : splitSample.getSubsamples().entrySet()) {
            Sample<LabelType> subSample = entry.getValue();
            double fraction = (double)subSample.size() / (double)sampleSize;
            conditionalEntropy += fraction * EntropyCounter.countEntropy(subSample.countClassFractions().values(), subSample.size());
        }
        return fullEntropy - conditionalEntropy;
    }
}

