/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.decisiontrees.id3;

import ru.ispras.ml.TrainingException;
import ru.ispras.ml.classification.IClassifier;
import ru.ispras.ml.classification.decisiontrees.DecisionTree;
import ru.ispras.ml.classification.decisiontrees.DecisionTreeClassifier;
import ru.ispras.ml.classification.decisiontrees.DecisionTreeModel;
import ru.ispras.ml.classification.decisiontrees.FeatureValuesInSample;
import ru.ispras.ml.classification.decisiontrees.IDecisionTreeTrainer;
import ru.ispras.ml.classification.decisiontrees.Sample;
import ru.ispras.ml.classification.decisiontrees.id3.ID3TreeBuilder;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;

public class ID3Trainer<LabelType>
implements IDecisionTreeTrainer<LabelType> {
    private static final long serialVersionUID = 3407298055138998217L;
    protected final ID3TreeBuilder treeBuilder = new ID3TreeBuilder();
    protected DecisionTreeModel model = null;

    @Override
    public DecisionTreeModel getModel() throws TrainingException {
        if (this.model == null) {
            throw new TrainingException("Model isn't trained");
        }
        return this.model;
    }

    @Override
    public void train(ILabelledInstance<LabelType> precedent) throws TrainingException {
        throw new TrainingException("Online training is not supported in ID3!");
    }

    @Override
    public void train(ILabeledDataset<LabelType> precedents) throws TrainingException {
        Sample<LabelType> sample = new Sample<LabelType>(precedents);
        FeatureValuesInSample featureSet = sample.getFeatureSet();
        DecisionTree tree = this.treeBuilder.buildSubtree(sample, featureSet, null);
        this.model = new DecisionTreeModel(tree);
    }

    @Override
    public IClassifier<LabelType> getPredictor() {
        return new DecisionTreeClassifier(this.model);
    }
}

