/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.decisiontrees;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import ru.ispras.ml.classification.decisiontrees.Sample;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.datamodel.value.IValue;

public class SplitSample<LabelType>
implements Serializable {
    private static final long serialVersionUID = 5098888978898708139L;
    private final Feature splitFeature;
    private final Map<IValue, Sample<LabelType>> subsamples;

    public SplitSample(Feature splitFeature, Map<IValue, Sample<LabelType>> subsamples) {
        this.splitFeature = splitFeature;
        this.subsamples = new HashMap<IValue, Sample<LabelType>>(subsamples);
    }

    public SplitSample(Feature splitFeature) {
        this.splitFeature = splitFeature;
        this.subsamples = new HashMap<IValue, Sample<LabelType>>();
    }

    public Feature getFeature() {
        return this.splitFeature;
    }

    public Map<IValue, Sample<LabelType>> getSubsamples() {
        return this.subsamples;
    }

    public void addClassifiedinstance(ILabelledInstance<LabelType> classifiedInstance) {
        if (!classifiedInstance.hasFeature(this.splitFeature)) {
            return;
        }
        IValue featureValue = classifiedInstance.getFeatureValue(this.splitFeature);
        if (featureValue == null) {
            return;
        }
        Sample<LabelType> subsample = this.getOrCreateSubsampleForValue(featureValue);
        subsample.addObject(classifiedInstance);
    }

    private Sample<LabelType> getOrCreateSubsampleForValue(IValue value) {
        if (this.subsamples.containsKey(value)) {
            return this.subsamples.get(value);
        }
        Sample subsample = new Sample();
        this.subsamples.put(value, subsample);
        return subsample;
    }

    public Sample getSubsampleForValue(IValue value) {
        return this.subsamples.get(value);
    }
}

