/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.decisiontrees;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.ispras.ml.classification.decisiontrees.FeatureValuesInSample;
import ru.ispras.ml.classification.decisiontrees.SplitSample;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.datamodel.ListLabelledDataset;
import ru.ispras.ml.datamodel.value.IValue;

public class Sample<LabelType>
implements Serializable {
    private static final long serialVersionUID = 2886900175891427394L;
    private List<ILabelledInstance<LabelType>> objects;

    public Sample() {
        this.objects = new ArrayList<ILabelledInstance<LabelType>>();
    }

    public Sample(ILabeledDataset<LabelType> dataset) {
        try (Stream stream = dataset.stream();){
            this.objects = dataset.stream().collect(Collectors.toList());
        }
    }

    public Sample(ListLabelledDataset<LabelType> dataset) {
        this.objects = dataset.getList();
    }

    public List<ILabelledInstance<LabelType>> getObjects() {
        return this.objects;
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public int size() {
        return this.objects.size();
    }

    public void addObject(ILabelledInstance<LabelType> obj) {
        this.objects.add(obj);
    }

    public FeatureValuesInSample getFeatureSet() {
        FeatureValuesInSample featureSet = new FeatureValuesInSample();
        for (ILabelledInstance<LabelType> object : this.objects) {
            for (Map.Entry<Feature, IValue> featureValue : object.getFeaturesValues().entrySet()) {
                Feature feature = featureValue.getKey();
                IValue value = featureValue.getValue();
                featureSet.addFeatureValue(feature, value);
            }
        }
        return featureSet;
    }

    public Map<LabelType, Integer> countClassFractions() {
        HashMap<LabelType, Integer> classRatings = new HashMap<LabelType, Integer>();
        for (ILabelledInstance<LabelType> object : this.objects) {
            LabelType classificationResult = object.getLabel();
            Integer value = (Integer)classRatings.get(classificationResult);
            int newValue = 1 + (value != null ? value : 0);
            classRatings.put(classificationResult, newValue);
        }
        return classRatings;
    }

    public SplitSample<LabelType> splitByFeature(Feature feature) {
        SplitSample<LabelType> splitSample = new SplitSample<LabelType>(feature);
        for (ILabelledInstance<LabelType> object : this.objects) {
            splitSample.addClassifiedinstance(object);
        }
        return splitSample;
    }

    public boolean equals(Object o) {
        if (o instanceof Sample) {
            Sample sample = (Sample)o;
            return this.objects.equals(sample.getObjects());
        }
        return false;
    }
}

