/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.decisiontrees;

import ru.ispras.ml.classification.ClassificationException;
import ru.ispras.ml.classification.ClassificationResult;
import ru.ispras.ml.classification.IClassifier;
import ru.ispras.ml.classification.decisiontrees.DecisionTree;
import ru.ispras.ml.classification.decisiontrees.DecisionTreeModel;
import ru.ispras.ml.datamodel.IInstance;

public class DecisionTreeClassifier<LabelType>
implements IClassifier<LabelType> {
    private static final long serialVersionUID = -8092533603577723045L;
    private final DecisionTreeModel model;

    public DecisionTreeClassifier(DecisionTreeModel model) {
        if (model == null) {
            throw new NullPointerException("Cannot create untrained classifier");
        }
        this.model = model;
    }

    private ClassificationResult<LabelType> treeClassify(DecisionTree node, IInstance instance) throws ClassificationException {
        if (node.getFeature() == null) {
            ClassificationResult result = node.getClassificationResult();
            if (result == null) {
                throw new ClassificationException("Cannot classify due to incomplete train data. Unclassifiable object: " + instance);
            }
            return result;
        }
        DecisionTree nextNode = node.getChildForValue(instance.getFeatureValue(node.getFeature()));
        if (nextNode == null) {
            throw new ClassificationException("Cannot classify due to incomplete train data. Unclassifiable object: " + instance + "\nBad value: " + instance.getFeatureValue(node.getFeature()) + " for the feature: " + node.getFeature());
        }
        return this.treeClassify(nextNode, instance);
    }

    @Override
    public ClassificationResult<LabelType> predict(IInstance instance) throws ClassificationException {
        return this.treeClassify(this.model.getRootNode(), instance);
    }
}

