/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.api.embedded.nlp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.ispras.texterra.api.embedded.nlp.EmbeddedTexterraNLP;
import ru.ispras.texterra.api.embedded.nlp.OverrideRegistry;
import ru.ispras.texterra.api.embedded.nlp.Registry;
import ru.ispras.texterra.api.utils.ConfigurationUtils;
import ru.ispras.texterra.core.configuration.TexterraConfiguration;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;
import ru.ispras.texterra.core.ekb.interfaces.TexterraKBM;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.tools.nlp.ITexterraNLP;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipelineRegistry;

public final class EmbeddedTexterraNLPFactory {
    public ITexterraNLP createDefault(TexterraKBM kbm) {
        return this.createNamed(TexterraConfiguration.NO_SCOPE, kbm);
    }

    public ITexterraNLP createNamed(String scope, TexterraKBM kbm) {
        return this.createCustom(this.createRegistryFromConfiguration(scope, kbm), this.createOverrideRegistries(scope, kbm));
    }

    public ITexterraNLP createCustom(GraphPipelineRegistry registry, Map<Class<? extends IAnnotation>, GraphPipelineRegistry> overrideRegistries) {
        return new EmbeddedTexterraNLP(registry, overrideRegistries);
    }

    private GraphPipelineRegistry createRegistryFromConfiguration(String scope, TexterraKBM kbm) {
        List registryProperties = TexterraConfigurationFactory.getConfiguration().getAllClassProperties(Registry.class, scope);
        if (registryProperties.size() != 1) {
            throw new TexterraConfigException(String.format("Exactly one registry should be specified for scope %s.", scope));
        }
        List moduleClasses = ((TexterraConfiguration.TexterraClassProperties)registryProperties.get(0)).getValues("moduleType");
        return this.createRegistryFromModuleTypes(moduleClasses, kbm);
    }

    private Map<Class<? extends IAnnotation>, GraphPipelineRegistry> createOverrideRegistries(String scope, TexterraKBM kbm) {
        HashMap<Class<? extends IAnnotation>, GraphPipelineRegistry> result = new HashMap<Class<? extends IAnnotation>, GraphPipelineRegistry>();
        List overrideRegistriesProperties = TexterraConfigurationFactory.getConfiguration().getAllClassProperties(OverrideRegistry.class, scope);
        for (TexterraConfiguration.TexterraClassProperties overrideRegistryProperties : overrideRegistriesProperties) {
            this.addOverrideRegistry(result, overrideRegistryProperties, kbm);
        }
        return result;
    }

    private void addOverrideRegistry(Map<Class<? extends IAnnotation>, GraphPipelineRegistry> result, TexterraConfiguration.TexterraClassProperties overrideRegistryProperties, TexterraKBM kbm) {
        List moduleTypes = overrideRegistryProperties.getValues("moduleType");
        List annotationTypes = overrideRegistryProperties.getValues("annotationType");
        GraphPipelineRegistry registry = this.createRegistryFromModuleTypes(moduleTypes, kbm);
        for (String annotationType : annotationTypes) {
            Class annotationClass = ConfigurationUtils.getType((String)annotationType, IAnnotation.class);
            if (result.containsKey(annotationClass)) {
                throw new TexterraConfigException(String.format("Duplicate override registered for %s type.", annotationClass));
            }
            result.put(annotationClass, registry);
        }
    }

    private GraphPipelineRegistry createRegistryFromModuleTypes(List<String> moduleTypes, TexterraKBM kbm) {
        GraphPipelineRegistry.Configuration configuration = new GraphPipelineRegistry.Configuration();
        for (String moduleType : moduleTypes) {
            Class moduleClass = ConfigurationUtils.getType((String)moduleType, GraphPipelineRegistry.IConfigurationModule.class);
            configuration.register(new GraphPipelineRegistry.IConfigurationModule[]{this.newModuleInstance(moduleClass, kbm)});
        }
        return new GraphPipelineRegistry(configuration);
    }

    private GraphPipelineRegistry.IConfigurationModule newModuleInstance(Class<? extends GraphPipelineRegistry.IConfigurationModule> moduleClass, TexterraKBM kbm) {
        try {
            moduleClass.getConstructor(TexterraKBM.class);
            return (GraphPipelineRegistry.IConfigurationModule)ConfigurationUtils.newInstance(moduleClass, (Class[])new Class[]{TexterraKBM.class}, (Object[])new Object[]{kbm});
        }
        catch (NoSuchMethodException e) {
            return (GraphPipelineRegistry.IConfigurationModule)ConfigurationUtils.newInstance(moduleClass, (Class[])new Class[0], (Object[])new Object[0]);
        }
    }
}

