/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.api.embedded.nlp;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.pipelines.IPipeline;
import ru.ispras.texterra.tools.nlp.ITexterraNLP;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipelineRegistry;

final class EmbeddedTexterraNLP
implements ITexterraNLP {
    private final GraphPipelineRegistry registry;
    private final Map<Class<? extends IAnnotation>, GraphPipelineRegistry> overrideRegistries;

    public EmbeddedTexterraNLP(GraphPipelineRegistry registry, Map<Class<? extends IAnnotation>, GraphPipelineRegistry> overrideRegistries) {
        this.registry = registry;
        this.overrideRegistries = ImmutableMap.copyOf(overrideRegistries);
    }

    public INLPDocument traverse(INLPDocument doc, ITexterraNLP.PipelineSpecification spec) {
        return this.getPipeline(spec).traverse(doc);
    }

    public List<? extends INLPDocument> traverse(List<? extends INLPDocument> docs, ITexterraNLP.PipelineSpecification spec) {
        return this.getPipeline(spec).traverse(docs);
    }

    private IPipeline getPipeline(ITexterraNLP.PipelineSpecification spec) {
        Map<GraphPipelineRegistry, Set<Class<? extends IAnnotation>>> registryToTargets = this.getRegistryToTargets(spec.getTargets());
        return doc -> registryToTargets.entrySet().parallelStream().map(registryAndTargets -> ((GraphPipelineRegistry)registryAndTargets.getKey()).getPipeline(new GraphPipelineRegistry.PipelineSpecification().withTargets((Collection)registryAndTargets.getValue()).withKnownOptions(spec.getKnownOptions()).withInputs((Collection)spec.getInputs()))).map(subPipeline -> subPipeline.traverse(doc)).reduce(doc.withoutAnnotations(), (res, elem) -> res.withAnnotations((Collection)elem.getAnnotations(IAnnotation.class)));
    }

    private Map<GraphPipelineRegistry, Set<Class<? extends IAnnotation>>> getRegistryToTargets(Set<Class<? extends IAnnotation>> targets) {
        return targets.stream().collect(Collectors.toMap(target -> this.getRegistryForTarget((Class<? extends IAnnotation>)target), ImmutableSet::of, (targets1, targets2) -> ImmutableSet.builder().addAll((Iterable)targets1).addAll((Iterable)targets2).build()));
    }

    private GraphPipelineRegistry getRegistryForTarget(Class<? extends IAnnotation> target) {
        return this.overrideRegistries.getOrDefault(target, this.registry);
    }
}

