/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.representation;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import ru.ispras.texterra.core.ekb.interfaces.IRepresentation;
import ru.ispras.texterra.core.ekb.interfaces.TexterraKBM;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentHelper;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.kbm.KBMAnnotation;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNode;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNodeDependencies;

public final class RepresentationAllTermsProvider<F extends IAnnotation>
implements IPipelineNodeProvider<F, IAnnotator<F>>,
Serializable {
    private static final long serialVersionUID = -560759073364373482L;
    private final Class<F> featureType;

    public RepresentationAllTermsProvider(Class<F> featureType) {
        this.featureType = (Class)Validate.notNull(featureType);
    }

    @Override
    public PipelineNode<F, IAnnotator<F>> get(NLPDocumentOptions options) {
        IRepresentation representation = ((TexterraKBM)options.getOption(KBMAnnotation.class)).getRepresentation();
        return new PipelineNode(new PipelineNodeDependencies().withSoftImplicitDependencies(KBMAnnotation.class).withSoftImplicitDependencies(representation.getRequiredInputs()), doc -> ((KBMAnnotation)NLPDocumentHelper.getAnnotation((INLPDocument)doc, KBMAnnotation.class)).getTexterraKBM().getRepresentation().getAllTerms(doc, new Class[]{this.featureType}).getAnnotations(this.featureType));
    }

    @Override
    public Set<Class<? extends IValuedAnnotation<?>>> getRequiredOptions() {
        return ImmutableSet.of(KBMAnnotation.class);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.featureType.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RepresentationAllTermsProvider)) {
            return false;
        }
        RepresentationAllTermsProvider other = (RepresentationAllTermsProvider)obj;
        return this.featureType.equals(other.featureType);
    }
}

