/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.representation;

import java.util.Collection;
import ru.ispras.texterra.core.ekb.interfaces.IRepresentation;
import ru.ispras.texterra.core.ekb.representation.TermCandidate;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.factories.DefaultDocumentFactory;
import ru.ispras.texterra.tools.nlp.ITexterraNLP;

public final class NLPPoweredRepresentation {
    private final IRepresentation representation;
    private final ITexterraNLP texterraNLP;
    private final ITexterraNLP.PipelineSpecification specification;

    public NLPPoweredRepresentation(IRepresentation representation, ITexterraNLP texterraNLP) {
        this.representation = representation;
        this.texterraNLP = texterraNLP;
        this.specification = new ITexterraNLP.PipelineSpecification().withTargets(representation.getRequiredInputs()).withTargets(TermCandidate.class).withInputs(TermCandidate.class);
    }

    public INLPDocument getTerms(INLPDocument doc, Collection<Class<? extends IAnnotation>> featuresTypes) {
        doc = this.texterraNLP.traverse(doc, this.specification);
        return this.representation.getTerms(doc, featuresTypes);
    }

    public INLPDocument getAllTerms(String text, Collection<Class<? extends IAnnotation>> featuresTypes) {
        INLPDocument doc = new DefaultDocumentFactory().create(text);
        doc = this.texterraNLP.traverse(doc, this.specification);
        return this.representation.getAllTerms(doc, featuresTypes);
    }
}

