/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.pipelines.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.pipelines.IPipeline;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipeline;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipelineRegistry;

public class PipelineInstantiationUtil {
    public static IPipeline getPipeline(String target, String ... modules) {
        try {
            return PipelineInstantiationUtil.getPipeline(Class.forName(target), Arrays.asList(modules));
        }
        catch (ClassNotFoundException e) {
            throw new TexterraConfigException("Cannot find class: " + target, (Throwable)e);
        }
    }

    public static IPipeline getPipeline(Class<? extends IAnnotation> target, String ... modules) {
        return PipelineInstantiationUtil.getPipeline(target, Arrays.asList(modules));
    }

    public static IPipeline getPipeline(Class<? extends IAnnotation> target, List<String> moduleNames) {
        return PipelineInstantiationUtil.getPipelineFromModules(target, PipelineInstantiationUtil.toModules(moduleNames));
    }

    private static List<GraphPipelineRegistry.IConfigurationModule> toModules(List<String> moduleNames) {
        return moduleNames.stream().map(moduleName -> PipelineInstantiationUtil.toModule(moduleName)).collect(Collectors.toList());
    }

    public static IPipeline getPipelineFromModules(Class<? extends IAnnotation> target, List<GraphPipelineRegistry.IConfigurationModule> modules) {
        GraphPipelineRegistry.Configuration configuration = new GraphPipelineRegistry.Configuration();
        final StringBuilder pipelineName = new StringBuilder(target.getSimpleName());
        for (GraphPipelineRegistry.IConfigurationModule module : modules) {
            pipelineName.append("-").append(module.getClass().getSimpleName());
            configuration.register(module);
        }
        final GraphPipeline targetPipeline = new GraphPipelineRegistry(configuration).getPipeline(new GraphPipelineRegistry.PipelineSpecification().withSoftImplicitTargets(target));
        return new IPipeline(){

            public INLPDocument traverse(INLPDocument doc) {
                return targetPipeline.traverse(doc);
            }

            public String toString() {
                return pipelineName.toString();
            }
        };
    }

    private static GraphPipelineRegistry.IConfigurationModule toModule(String module) {
        try {
            return (GraphPipelineRegistry.IConfigurationModule)Class.forName(module).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new TexterraConfigException("Cannot instantiate module: " + module, (Throwable)e);
        }
    }
}

