/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.pipelines.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.pipelines.graph.ConstantPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNode;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNodeDependencies;

public final class UnionPipelineNodeProvider<A extends IAnnotation>
implements IPipelineNodeProvider<A, IAnnotator<A>>,
Serializable {
    private static final long serialVersionUID = 2328083976876899428L;
    private final Class<A> type;
    private final Collection<? extends IPipelineNodeProvider<? extends A, ?>> providers;

    public UnionPipelineNodeProvider(Class<A> type, Collection<? extends IPipelineNodeProvider<? extends A, ?>> providers) {
        this.type = (Class)Validate.notNull(type);
        this.providers = (Collection)Validate.notNull(providers);
    }

    @SafeVarargs
    public UnionPipelineNodeProvider(Class<A> type, IPipelineNodeProvider<? extends A, ?> ... providers) {
        this(type, Arrays.asList(providers));
    }

    @Override
    public PipelineNode<A, IAnnotator<A>> get(NLPDocumentOptions options) {
        return new PipelineNode(new PipelineNodeDependencies().withSoftExplicitDependencies(this.providers), new Annotator<A>(this.type));
    }

    @Override
    public Set<Class<? extends IValuedAnnotation<?>>> getRequiredOptions() {
        return Collections.emptySet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.providers.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnionPipelineNodeProvider other = (UnionPipelineNodeProvider)obj;
        return this.type.equals(other.type) && this.providers.equals(other.providers);
    }

    @SafeVarargs
    public static <A extends IAnnotation> UnionPipelineNodeProvider<A> forNodes(Class<A> type, PipelineNode<A, ?> ... nodes) {
        ArrayList result = new ArrayList();
        for (PipelineNode<A, ?> node : nodes) {
            result.add(new ConstantPipelineNodeProvider(node));
        }
        return new UnionPipelineNodeProvider<A>(type, result);
    }

    private static final class Annotator<A extends IAnnotation>
    implements ISerializableAnnotator<A> {
        private static final long serialVersionUID = 2115406687793054843L;
        private final Class<A> type;

        public Annotator(Class<A> type) {
            this.type = type;
        }

        public Collection<A> annotate(INLPDocument doc) {
            return doc.getAnnotations(this.type);
        }
    }
}

