/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.pipelines.graph;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNode;

public final class PipelineNodeDependencies
implements Serializable {
    private static final long serialVersionUID = -1479863731104707284L;
    private final Set<Class<? extends IAnnotation>> softImplicitDependencies;
    private final Set<IPipelineNodeProvider<?, ?>> softExplicitDependencies;
    private final Set<PipelineNode<?, ?>> hardDependencies;

    private PipelineNodeDependencies(Set<Class<? extends IAnnotation>> softImplicitDependencies, Set<IPipelineNodeProvider<?, ?>> softExplicitDependencies, Set<PipelineNode<?, ?>> hardDependencies) {
        this.softImplicitDependencies = softImplicitDependencies;
        this.softExplicitDependencies = softExplicitDependencies;
        this.hardDependencies = hardDependencies;
    }

    public PipelineNodeDependencies() {
        this((Set<Class<? extends IAnnotation>>)ImmutableSet.of(), (Set<IPipelineNodeProvider<?, ?>>)ImmutableSet.of(), (Set<PipelineNode<?, ?>>)ImmutableSet.of());
    }

    public Set<Class<? extends IAnnotation>> getSoftImplicitDependencies() {
        return this.softImplicitDependencies;
    }

    public PipelineNodeDependencies withSoftImplicitDependencies(Collection<Class<? extends IAnnotation>> deps) {
        return new PipelineNodeDependencies(this.plus(this.softImplicitDependencies, deps), this.softExplicitDependencies, this.hardDependencies);
    }

    @SafeVarargs
    public final PipelineNodeDependencies withSoftImplicitDependencies(Class<? extends IAnnotation> ... deps) {
        return this.withSoftImplicitDependencies(Arrays.asList(deps));
    }

    public Set<IPipelineNodeProvider<?, ?>> getSoftExplicitDependencies() {
        return this.softExplicitDependencies;
    }

    public PipelineNodeDependencies withSoftExplicitDependencies(Collection<? extends IPipelineNodeProvider<?, ?>> deps) {
        return new PipelineNodeDependencies(this.softImplicitDependencies, this.plus(this.softExplicitDependencies, deps), this.hardDependencies);
    }

    public PipelineNodeDependencies withSoftExplicitDependencies(IPipelineNodeProvider<?, ?> ... deps) {
        return this.withSoftExplicitDependencies(Arrays.asList(deps));
    }

    public Set<PipelineNode<?, ?>> getHardDependencies() {
        return this.hardDependencies;
    }

    public PipelineNodeDependencies withHardDependencies(Collection<PipelineNode<?, ?>> deps) {
        return new PipelineNodeDependencies(this.softImplicitDependencies, this.softExplicitDependencies, this.plus(this.hardDependencies, deps));
    }

    public PipelineNodeDependencies withHardDependencies(PipelineNode<?, ?> ... deps) {
        return this.withHardDependencies(Arrays.asList(deps));
    }

    private <T> Set<T> plus(Set<T> first, Collection<? extends T> second) {
        return new ImmutableSet.Builder().addAll(first).addAll(second).build();
    }
}

