/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.pipelines.graph;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNode;

public final class PipelineNodeCache {
    private final ConcurrentMap<CacheKey, PipelineNode<?, ?>> cache = new ConcurrentHashMap();
    private final ConcurrentMap<CacheKey, CacheKey> keyCache = new ConcurrentHashMap<CacheKey, CacheKey>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends IAnnotation, T extends IAnnotator<A>> PipelineNode<A, T> getCachedPipelineNode(IPipelineNodeProvider<A, T> pipelineNodeProvider, NLPDocumentOptions requiredOptions) {
        CacheKey key = new CacheKey(pipelineNodeProvider, requiredOptions);
        PipelineNode<A, T> value = (PipelineNode<A, T>)this.cache.get(key);
        if (value != null) {
            return value;
        }
        this.keyCache.putIfAbsent(key, key);
        key = this.keyCache.getOrDefault(key, key);
        try {
            CacheKey cacheKey = key;
            synchronized (cacheKey) {
                block9: {
                    value = (PipelineNode)this.cache.get(key);
                    if (value == null) break block9;
                    PipelineNode<A, T> pipelineNode = value;
                    return pipelineNode;
                }
                value = pipelineNodeProvider.get(requiredOptions);
                this.cache.put(key, value);
            }
        }
        finally {
            this.keyCache.remove(key);
        }
        return value;
    }

    private static final class CacheKey {
        private final IPipelineNodeProvider<?, ?> pipelineNodeProvider;
        private final NLPDocumentOptions options;

        public CacheKey(IPipelineNodeProvider<?, ?> pipelineNodeProvider, NLPDocumentOptions options) {
            this.pipelineNodeProvider = pipelineNodeProvider;
            this.options = options;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
            result = 31 * result + (this.pipelineNodeProvider == null ? 0 : this.pipelineNodeProvider.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.options == null ? other.options != null : !this.options.equals(other.options)) {
                return false;
            }
            return !(this.pipelineNodeProvider == null ? other.pipelineNodeProvider != null : !this.pipelineNodeProvider.equals(other.pipelineNodeProvider));
        }
    }
}

