/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.pipelines.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.pipelines.graph.CompiledGraphPipeline;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipelineNode;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipelineRegistry;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.KnownAnnotationsGraphPipelineNode;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineComputer;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNode;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNodeDependencies;

class PipelineBuilder {
    private final PipelineComputer pipelineComputer;
    private final GraphPipelineRegistry registry;
    private final Set<Class<? extends IAnnotation>> knownAnnotationTypes;
    private final Set<Class<? extends IValuedAnnotation<?>>> blockedOptions;
    private final Set<IPipelineNodeProvider<?, ?>> blockedProviders;
    private NLPDocumentOptions knownDocumentOptions;

    public PipelineBuilder(GraphPipelineRegistry registry, PipelineComputer pipelineComputer, NLPDocumentOptions options, Set<Class<? extends IAnnotation>> knownAnnotationTypes) {
        this.registry = registry;
        this.pipelineComputer = pipelineComputer;
        this.knownAnnotationTypes = new HashSet<Class<? extends IAnnotation>>(knownAnnotationTypes);
        this.knownAnnotationTypes.addAll(options.getSpecifiedOptionTypes());
        this.knownDocumentOptions = options;
        this.blockedOptions = new HashSet();
        this.blockedProviders = new HashSet();
    }

    public <A extends IAnnotation> CompiledGraphPipeline<A> buildPipeline(Class<A> annotationType) {
        GraphPipelineNode<A, IAnnotator<A>> pipelineNode = this.buildPipelineNode(annotationType);
        return this.buildPipeline(pipelineNode);
    }

    public <A extends IAnnotation> CompiledGraphPipeline<A> buildPipeline(GraphPipelineNode<A, ? extends IAnnotator<A>> pipelineNode) {
        CompiledGraphPipeline<A> compiledGraphPipeline = CompiledGraphPipeline.compile(pipelineNode);
        return compiledGraphPipeline;
    }

    private <A extends IAnnotation> GraphPipelineNode<A, ? extends IAnnotator<A>> buildPipelineNode(Class<A> annotationType) {
        if (this.knownAnnotationTypes.contains(annotationType)) {
            return new KnownAnnotationsGraphPipelineNode<A>(annotationType);
        }
        IPipelineNodeProvider<A, IAnnotator<A>> pipelineNodeProvider = this.getPipelineNodeProvider(annotationType);
        return this.buildPipelineNode(pipelineNodeProvider);
    }

    private <A extends IAnnotation, T extends IAnnotator<A>> GraphPipelineNode<A, T> buildPipelineNode(IPipelineNodeProvider<A, T> pipelineNodeProvider) {
        if (this.blockedProviders.contains(pipelineNodeProvider)) {
            throw new TexterraSystemException(String.format("Circular reference in registry: %s", pipelineNodeProvider));
        }
        this.blockedProviders.add(pipelineNodeProvider);
        NLPDocumentOptions options = this.getOptions(pipelineNodeProvider.getRequiredOptions());
        PipelineNode<A, T> pipelineNode = this.registry.getCachedPipelineNode(pipelineNodeProvider, options);
        GraphPipelineNode<A, T> result = this.buildPipelineNode(pipelineNode);
        this.blockedProviders.remove(pipelineNodeProvider);
        return result;
    }

    private <A extends IAnnotation, T extends IAnnotator<A>> GraphPipelineNode<A, T> buildPipelineNode(PipelineNode<A, T> pipelineNode) {
        return new GraphPipelineNode(pipelineNode.getDocumentFactory(), this.buildDependencies(pipelineNode.getDependencies()), pipelineNode.getAnnotator());
    }

    public Set<GraphPipelineNode<?, ?>> buildDependencies(PipelineNodeDependencies dependencies) {
        HashSet result = new HashSet();
        for (PipelineNode<?, ?> pipelineNode : dependencies.getHardDependencies()) {
            result.add(this.buildPipelineNode(pipelineNode));
        }
        for (IPipelineNodeProvider iPipelineNodeProvider : dependencies.getSoftExplicitDependencies()) {
            result.add(this.buildPipelineNode(iPipelineNodeProvider));
        }
        for (Class clazz : dependencies.getSoftImplicitDependencies()) {
            result.add(this.buildPipelineNode(clazz));
        }
        return result;
    }

    private <A extends IAnnotation> IPipelineNodeProvider<A, ? extends IAnnotator<A>> getPipelineNodeProvider(Class<A> annotationType) {
        Set<Class<? extends IValuedAnnotation<?>>> requiredOptionTypes = this.registry.getRequiredOptionTypes(annotationType);
        NLPDocumentOptions requiredOptions = this.getOptions(requiredOptionTypes);
        IPipelineNodeProvider<A, IAnnotator<A>> pipelineNodeProvider = this.registry.getPipelineNodeProvider(annotationType, requiredOptions);
        return pipelineNodeProvider;
    }

    private NLPDocumentOptions getOptions(Set<Class<? extends IValuedAnnotation<?>>> optionTypes) {
        NLPDocumentOptions result = this.knownDocumentOptions.filter(optionTypes);
        HashSet notPresented = new HashSet(optionTypes);
        notPresented.removeAll(result.getSpecifiedOptionTypes());
        for (Class clazz : notPresented) {
            if (this.blockedOptions.contains(clazz)) {
                throw new TexterraSystemException(String.format("Circular reference in registry: %s.", clazz));
            }
            this.blockedOptions.add(clazz);
            CompiledGraphPipeline compiledPipeline = this.buildPipeline(clazz);
            this.blockedOptions.remove(clazz);
            Collection computedOptions = this.pipelineComputer.compute(compiledPipeline);
            IValuedAnnotation computedOption = (IValuedAnnotation)computedOptions.iterator().next();
            result = result.withOption(computedOption);
        }
        this.knownDocumentOptions = this.knownDocumentOptions.withOptions(result);
        return result;
    }
}

