/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.pipelines.graph;

import java.util.Collection;
import java.util.Collections;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.pipelines.IPipeline;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipelineNode;

class KnownAnnotationsGraphPipelineNode<A extends IAnnotation>
extends GraphPipelineNode<A, IAnnotator<A>> {
    protected KnownAnnotationsGraphPipelineNode(Class<A> annotationType) {
        super(new IPipeline(){

            public INLPDocument traverse(INLPDocument doc) {
                return doc;
            }
        }, Collections.emptySet(), new StubAnnotator<A>(annotationType));
    }

    private static class StubAnnotator<A extends IAnnotation>
    implements ISerializableAnnotator<A> {
        private static final long serialVersionUID = 5964730831345741252L;
        private final Class<A> annotationType;

        public StubAnnotator(Class<A> annotationType) {
            this.annotationType = annotationType;
        }

        public Collection<A> annotate(INLPDocument doc) {
            return doc.getAnnotations(this.annotationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.annotationType == null ? 0 : this.annotationType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StubAnnotator)) {
                return false;
            }
            StubAnnotator other = (StubAnnotator)obj;
            return !(this.annotationType == null ? other.annotationType != null : !this.annotationType.equals(other.annotationType));
        }
    }
}

