/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.pipelines.graph;

import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNode;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNodeDependencies;

public final class ImplicitPipelineNodeProvider<A extends IAnnotation>
implements IPipelineNodeProvider<A, IAnnotator<A>>,
Serializable {
    private static final long serialVersionUID = -6171293356538296876L;
    private final Class<A> annotationType;

    public ImplicitPipelineNodeProvider(Class<A> annotationType) {
        this.annotationType = Objects.requireNonNull(annotationType);
    }

    @Override
    public PipelineNode<A, IAnnotator<A>> get(NLPDocumentOptions options) {
        return new PipelineNode(new PipelineNodeDependencies().withSoftImplicitDependencies(this.annotationType), doc -> doc.getAnnotations(this.annotationType));
    }

    @Override
    public Set<Class<? extends IValuedAnnotation<?>>> getRequiredOptions() {
        return Collections.emptySet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.annotationType.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImplicitPipelineNodeProvider other = (ImplicitPipelineNodeProvider)obj;
        return this.annotationType.equals(other.annotationType);
    }
}

