/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.pipelines.graph;

import java.util.Set;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.factories.IDocumentFactory;
import ru.ispras.texterra.core.nlp.pipelines.IPipeline;

class GraphPipelineNode<A extends IAnnotation, T extends IAnnotator<A>> {
    private final IPipeline pretreatmentPipeline;
    private final Set<GraphPipelineNode<?, ?>> dependencies;
    private final T annotator;

    public GraphPipelineNode(final IDocumentFactory documentFactory, Set<GraphPipelineNode<?, ?>> dependencies, T annotator) {
        this(new IPipeline(){

            public INLPDocument traverse(INLPDocument doc) {
                return documentFactory.create(doc.getText());
            }
        }, dependencies, annotator);
    }

    protected GraphPipelineNode(IPipeline pretreatmentPipeline, Set<GraphPipelineNode<?, ?>> dependencies, T annotator) {
        this.pretreatmentPipeline = pretreatmentPipeline;
        this.dependencies = dependencies;
        this.annotator = annotator;
    }

    public IPipeline getDocumentPretreatmentPipeline() {
        return this.pretreatmentPipeline;
    }

    public Set<GraphPipelineNode<?, ?>> getDependencies() {
        return this.dependencies;
    }

    public T getAnnotator() {
        return this.annotator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotator == null ? 0 : this.annotator.hashCode());
        result = 31 * result + (this.dependencies == null ? 0 : this.dependencies.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphPipelineNode)) {
            return false;
        }
        GraphPipelineNode other = (GraphPipelineNode)obj;
        if (this.annotator == null ? other.annotator != null : !this.annotator.equals(other.annotator)) {
            return false;
        }
        return !(this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies));
    }
}

