/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.pipelines.graph;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.core.nlp.pipelines.IPipeline;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.pipelines.graph.CompiledGraphPipeline;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipelineNode;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipelineRegistry;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineBuilder;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineComputer;

public final class GraphPipeline
implements IPipeline,
Serializable {
    private static final long serialVersionUID = -3643421264703536652L;
    private final GraphPipelineRegistry registry;
    private final GraphPipelineRegistry.PipelineSpecification specification;

    public GraphPipeline(GraphPipelineRegistry registry, GraphPipelineRegistry.PipelineSpecification specification) {
        this.registry = registry;
        this.specification = specification;
    }

    public INLPDocument traverse(INLPDocument doc) {
        doc = this.normalizeDocument(doc);
        PipelineComputer pipelineComputer = new PipelineComputer(doc);
        PipelineBuilder builder = new PipelineBuilder(this.registry, pipelineComputer, this.specification.getKnownOptions(), this.specification.getInputs());
        doc = this.createResultDoc(doc);
        for (GraphPipelineNode<?, ?> pipelineNode : builder.buildDependencies(this.specification.getTargets())) {
            CompiledGraphPipeline<?> compiledPipeline = builder.buildPipeline(pipelineNode);
            Collection<?> annotations = pipelineComputer.compute(compiledPipeline);
            doc = doc.withAnnotations(annotations);
        }
        return doc;
    }

    private INLPDocument normalizeDocument(INLPDocument doc) {
        NLPDocumentOptions options = this.specification.getKnownOptions();
        for (Class<? extends IValuedAnnotation<?>> clazz : options.getSpecifiedOptionTypes()) {
            Object knownOptionValue = options.getOption(clazz);
            if (this.specification.getInputs().contains(clazz)) {
                List storedAnnotations = doc.getAnnotations(clazz);
                if (storedAnnotations.size() != 1) {
                    throw new TexterraSystemException("Document should contains the only options annotation " + clazz);
                }
                IValuedAnnotation optionAnnotation = (IValuedAnnotation)storedAnnotations.get(0);
                Object optionAnnotationValue = optionAnnotation.getValue();
                if (knownOptionValue.equals(optionAnnotationValue) && this.isCoverWholeDocument(doc, (IAnnotation)optionAnnotation)) continue;
                throw new TexterraSystemException("Can't process document with " + optionAnnotation + " with " + this.specification + " pipeline");
            }
            IValuedAnnotation<?> optionAnnotation = this.createAnnotation(clazz, knownOptionValue, doc);
            doc = doc.withAnnotations(Arrays.asList(optionAnnotation));
        }
        return doc;
    }

    private boolean isCoverWholeDocument(INLPDocument doc, IAnnotation annotation) {
        return annotation.getStart() == 0 && annotation.getEnd() == doc.getText().length();
    }

    private <T extends IValuedAnnotation<?>> T createAnnotation(Class<T> type, Object value, INLPDocument doc) {
        try {
            Constructor<T> constructor = this.getConstructor(type, value.getClass());
            return (T)((IValuedAnnotation)constructor.newInstance(doc, value));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new TexterraSystemException("Can't instantiate " + type + " annotation", (Throwable)e);
        }
    }

    private <T extends IValuedAnnotation<?>> Constructor<T> getConstructor(Class<T> annotationType, Class<?> valueType) throws NoSuchMethodException {
        for (Constructor<?> constructor : annotationType.getConstructors()) {
            Class<?>[] parameters = constructor.getParameterTypes();
            if (parameters.length != 2 || !parameters[0].equals(INLPDocument.class) || !parameters[1].isAssignableFrom(valueType)) continue;
            return constructor;
        }
        throw new NoSuchMethodException("Can't find appropriate constructor for " + annotationType + " annotation type with " + valueType + " value type.");
    }

    private INLPDocument createResultDoc(INLPDocument doc) {
        if (this.specification.shouldPreserveInputDocumentFactory()) {
            return doc.withoutAnnotations();
        }
        return this.specification.getDocumentFactory().create(doc.getText());
    }
}

