/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.pipelines.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipelineNode;

class CompiledGraphPipeline<A extends IAnnotation> {
    private final Map<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> dependencies;
    private final GraphPipelineNode<A, ? extends IAnnotator<A>> target;

    public CompiledGraphPipeline(Map<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> dependencies, GraphPipelineNode<A, ? extends IAnnotator<A>> target) {
        this.dependencies = dependencies;
        this.target = target;
    }

    public Map<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> getDependencies() {
        return this.dependencies;
    }

    public GraphPipelineNode<A, ? extends IAnnotator<A>> getTarget() {
        return this.target;
    }

    public static <A extends IAnnotation> CompiledGraphPipeline<A> compile(GraphPipelineNode<A, ?> pipeline) {
        Map<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> dependencies = CompiledGraphPipeline.addDependencies(new HashMap(), pipeline);
        return new CompiledGraphPipeline<A>(dependencies, pipeline);
    }

    private static Map<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> addDependencies(Map<GraphPipelineNode<?, ?>, Set<GraphPipelineNode<?, ?>>> dependencies, GraphPipelineNode<?, ?> currentNode) {
        if (dependencies.containsKey(currentNode)) {
            return dependencies;
        }
        dependencies.put(currentNode, currentNode.getDependencies());
        for (GraphPipelineNode<?, ?> childNode : currentNode.getDependencies()) {
            dependencies = CompiledGraphPipeline.addDependencies(dependencies, childNode);
        }
        return dependencies;
    }
}

