/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.modelsio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import ru.ispras.modis.utils.ClasspathUtils;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.modelsio.AbstractOptionsBasedModelsIO;

public final class ZippedBinaryOptionsBasedModelsIO<M>
extends AbstractOptionsBasedModelsIO<M>
implements Serializable {
    private static final long serialVersionUID = -4616384447052020643L;
    private final String modelName;

    public ZippedBinaryOptionsBasedModelsIO(String modelName) {
        this.modelName = modelName;
    }

    public ZippedBinaryOptionsBasedModelsIO(Class<M> type) {
        this(type.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public M load(NLPDocumentOptions options) {
        String modelsPath = this.getModelsPath(options);
        try (ObjectInputStream ois = new ObjectInputStream(new InflaterInputStream(ClasspathUtils.getResourceAsStream((String)modelsPath, (String)this.modelName)));){
            Object object;
            Object object2 = object = ois.readObject();
            return (M)object2;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new TexterraConfigException(String.format("Can not load %s for %s NLP document options.", this.modelName, options), (Throwable)e);
        }
    }

    @Override
    public void save(NLPDocumentOptions options, M model) {
        String modelsPath = this.getSaveModelsPath(options);
        try (ObjectOutputStream oos = new ObjectOutputStream(new DeflaterOutputStream(new FileOutputStream(new File(modelsPath, this.modelName))));){
            oos.writeObject(model);
        }
        catch (IOException e) {
            throw new TexterraConfigException(String.format("Can not save %s for %s NLP document options.", this.modelName, options), (Throwable)e);
        }
    }
}

