/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.modelsio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import ru.ispras.modis.utils.ClasspathUtils;
import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.texterra.core.common.concept.Domain;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.datamodel.DomainAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.IsTweet;
import ru.ispras.texterra.core.nlp.datamodel.Language;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.utils.language.ITexterraLanguage;

public abstract class AbstractOptionsBasedModelsIO<M> {
    @ConfigurationProperty
    private static final String modelsPathProperty = "modelsPath";

    protected String getModelsPath(NLPDocumentOptions options) {
        String modelPath = "";
        if (options.containsOption(Language.class)) {
            modelPath = this.appendPath(modelPath, this.getLanguagePath((ITexterraLanguage)options.getOption(Language.class)));
        }
        if (options.containsOption(DomainAnnotation.class)) {
            modelPath = this.appendPath(modelPath, this.getDomainPath((Domain)options.getOption(DomainAnnotation.class)));
        }
        if (options.containsOption(IsTweet.class)) {
            modelPath = this.appendPath(modelPath, this.getIsTweetPath((Boolean)options.getOption(IsTweet.class)));
        }
        if (modelPath.isEmpty()) {
            throw new TexterraSystemException("can't resolve model path: empty NLP document options");
        }
        return modelPath;
    }

    protected String getSaveModelsPath(NLPDocumentOptions options) {
        String modelPath = this.appendPath("src/main/resources", this.getModelsPath(options));
        new File(modelPath).mkdirs();
        return modelPath;
    }

    private String getLanguagePath(ITexterraLanguage language) {
        return TexterraConfigurationFactory.getConfiguration().getStringProperty(AbstractOptionsBasedModelsIO.class, modelsPathProperty, language.getLanguageTag());
    }

    private String getDomainPath(Domain domain) {
        return domain.getDomainName();
    }

    private String getIsTweetPath(boolean isTweet) {
        return isTweet ? "twitter" : "non-twitter";
    }

    private String appendPath(String path, String increment) {
        return path.isEmpty() ? increment : path + '/' + increment;
    }

    public static File makeFileFromResource(String resourceName) throws IOException {
        InputStream resource = ClasspathUtils.getResourceAsStream((String)resourceName);
        File tempFile = File.createTempFile(resourceName.replace(File.separatorChar, '.'), ".tmp");
        IOUtils.copy((InputStream)resource, (OutputStream)new FileOutputStream(tempFile));
        return tempFile;
    }

    public abstract M load(NLPDocumentOptions var1);

    public abstract void save(NLPDocumentOptions var1, M var2);
}

