/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.syntax.transform;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import ru.ispras.texterra.core.nlp.datamodel.IToken;

public class ConllXToken {
    private static final String EMPTY_VALUE = "_";
    private static final int EMPTY_INT_VALUE = -1;
    private final IToken original;
    private final int id;
    private final String form;
    private final String cposTag;
    private final String posTag;
    private final String lemma;
    private final Set<String> feats;
    private final int head;
    private final String depRel;

    public ConllXToken(ConllXToken token, int head, String depRel) {
        this(token.original, token.id, token.form, token.cposTag, token.posTag, token.lemma, token.feats, head, depRel);
    }

    public ConllXToken(IToken original, int id, String form, String cposTag, String posTag, String lemma, Collection<String> feats) {
        this(original, id, form, cposTag, posTag, lemma, feats, -1, EMPTY_VALUE);
    }

    private ConllXToken(IToken original, int id, String form, String cposTag, String posTag, String lemma, Collection<String> feats, int head, String depRel) {
        this.original = original;
        this.id = id;
        this.form = ConllXToken.normalizeConllXField(form);
        this.cposTag = ConllXToken.normalizeConllXField(cposTag);
        this.posTag = ConllXToken.normalizeConllXField(posTag);
        this.lemma = ConllXToken.normalizeConllXField(lemma);
        this.feats = feats == null ? Collections.emptySet() : new HashSet<String>(feats);
        this.head = head;
        this.depRel = ConllXToken.normalizeConllXField(depRel);
    }

    private static String normalizeConllXField(String value) {
        return value.isEmpty() ? EMPTY_VALUE : value;
    }

    public IToken getOriginal() {
        return this.original;
    }

    public int getId() {
        return this.id;
    }

    public String getForm() {
        return this.form;
    }

    public String getCposTag() {
        return this.cposTag;
    }

    public String getPosTag() {
        return this.posTag;
    }

    public String getLemma() {
        return this.lemma;
    }

    public Set<String> getFeats() {
        return this.feats;
    }

    public int getHead() {
        return this.head;
    }

    public String getDepRel() {
        return this.depRel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cposTag == null ? 0 : this.cposTag.hashCode());
        result = 31 * result + (this.depRel == null ? 0 : this.depRel.hashCode());
        result = 31 * result + (this.feats == null ? 0 : this.feats.hashCode());
        result = 31 * result + (this.form == null ? 0 : this.form.hashCode());
        result = 31 * result + this.head;
        result = 31 * result + this.id;
        result = 31 * result + (this.lemma == null ? 0 : this.lemma.hashCode());
        result = 31 * result + (this.original == null ? 0 : this.original.hashCode());
        result = 31 * result + (this.posTag == null ? 0 : this.posTag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConllXToken)) {
            return false;
        }
        ConllXToken other = (ConllXToken)obj;
        if (this.cposTag == null ? other.cposTag != null : !this.cposTag.equals(other.cposTag)) {
            return false;
        }
        if (this.depRel == null ? other.depRel != null : !this.depRel.equals(other.depRel)) {
            return false;
        }
        if (this.feats == null ? other.feats != null : !this.feats.equals(other.feats)) {
            return false;
        }
        if (this.form == null ? other.form != null : !this.form.equals(other.form)) {
            return false;
        }
        if (this.head != other.head) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.lemma == null ? other.lemma != null : !this.lemma.equals(other.lemma)) {
            return false;
        }
        if (this.original == null ? other.original != null : !this.original.equals(other.original)) {
            return false;
        }
        return !(this.posTag == null ? other.posTag != null : !this.posTag.equals(other.posTag));
    }

    public String toString() {
        return ConllXToken.charSeparated('\t', this.id, this.form, this.lemma, this.cposTag, this.posTag, ConllXToken.charSeparated('|', this.feats.toArray()), this.head, this.depRel, EMPTY_VALUE, EMPTY_VALUE);
    }

    private static String charSeparated(char c, Object ... objects) {
        if (objects.length == 0) {
            return EMPTY_VALUE;
        }
        StringBuilder builder = new StringBuilder();
        for (Object o : objects) {
            builder = builder.append(o).append(c);
        }
        return ConllXToken.normalizeConllXField(builder.substring(0, Math.max(0, builder.length() - 1)));
    }
}

