/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.syntax.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.ConllXToken;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;

public class ConllXSentence
implements Iterable<ConllXToken> {
    private final Sentence original;
    private final List<ConllXToken> tokens;

    public ConllXSentence(Sentence original, List<ConllXToken> tokens) {
        this.original = original;
        this.tokens = tokens;
    }

    public Sentence getOriginal() {
        return this.original;
    }

    public List<ConllXToken> getTokens() {
        return this.tokens;
    }

    public List<String> getStringTokens() {
        ArrayList<String> result = new ArrayList<String>(this.tokens.size());
        for (ConllXToken token : this.tokens) {
            result.add(token.toString());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.original == null ? 0 : this.original.hashCode());
        result = 31 * result + (this.tokens == null ? 0 : this.tokens.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConllXSentence)) {
            return false;
        }
        ConllXSentence other = (ConllXSentence)obj;
        if (this.original == null ? other.original != null : !this.original.equals((Object)other.original)) {
            return false;
        }
        return !(this.tokens == null ? other.tokens != null : !this.tokens.equals(other.tokens));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ConllXToken token : this.tokens) {
            builder = builder.append(token.toString()).append("\n");
        }
        return builder.toString();
    }

    @Override
    public Iterator<ConllXToken> iterator() {
        return this.tokens.iterator();
    }
}

