/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.syntax.transform;

import java.util.Iterator;
import java.util.List;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.ConllXSentence;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;

public class ConllXDocument
implements Iterable<ConllXSentence> {
    private final INLPDocument original;
    private final List<ConllXSentence> sentences;

    public ConllXDocument(INLPDocument original, List<ConllXSentence> sentences) {
        this.original = original;
        this.sentences = sentences;
    }

    public INLPDocument getOriginal() {
        return this.original;
    }

    public List<ConllXSentence> getSentences() {
        return this.sentences;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.original == null ? 0 : this.original.hashCode());
        result = 31 * result + (this.sentences == null ? 0 : this.sentences.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConllXDocument)) {
            return false;
        }
        ConllXDocument other = (ConllXDocument)obj;
        if (this.original == null ? other.original != null : !this.original.equals(other.original)) {
            return false;
        }
        return !(this.sentences == null ? other.sentences != null : !this.sentences.equals(other.sentences));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ConllXSentence sentence : this.sentences) {
            builder = builder.append(sentence.toString()).append("\n");
        }
        return builder.toString();
    }

    @Override
    public Iterator<ConllXSentence> iterator() {
        return this.sentences.iterator();
    }
}

