/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.syntax.transform;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.ConllXDocument;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.ConllXSentence;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.ConllXToken;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.syntax.ISyntaxRelationValue;
import ru.ispras.texterra.core.nlp.datamodel.syntax.RootSyntaxRelationValue;
import ru.ispras.texterra.core.nlp.datamodel.syntax.SyntaxRelation;
import ru.ispras.texterra.core.nlp.datamodel.syntax.SyntaxRelationValue;

public class ConllX2NLPDocumentTransformer {
    public Collection<SyntaxRelation> transform(ConllXDocument conllDoc) {
        ArrayList<SyntaxRelation> result = new ArrayList<SyntaxRelation>();
        for (ConllXSentence sentence : conllDoc) {
            result.addAll(this.transformSentence(sentence));
        }
        return result;
    }

    private Collection<SyntaxRelation> transformSentence(ConllXSentence sentence) {
        TIntObjectHashMap id2ConllXToken = new TIntObjectHashMap();
        for (ConllXToken token : sentence) {
            id2ConllXToken.put(token.getId(), (Object)token);
        }
        ArrayList<SyntaxRelation> result = new ArrayList<SyntaxRelation>();
        for (ConllXToken token : sentence) {
            RootSyntaxRelationValue srValue;
            int parentToken = token.getHead();
            if (parentToken == 0) {
                srValue = new RootSyntaxRelationValue();
            } else {
                ConllXToken headToken = (ConllXToken)id2ConllXToken.get(token.getHead());
                if (headToken == null) {
                    throw new TexterraSystemException("broken syntax graph of the following sentence: " + sentence.getOriginal());
                }
                srValue = new SyntaxRelationValue(headToken.getOriginal(), token.getDepRel());
            }
            result.add(new SyntaxRelation((IAnnotation)token.getOriginal(), (ISyntaxRelationValue)srValue));
        }
        return result;
    }
}

