/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.nlp;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import ru.ispras.texterra.core.cli.nlp.FilteringOptions;
import ru.ispras.texterra.core.cli.nlp.PipelineProcessor;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.utils.NLPDocumentFilteringUtils;
import ru.ispras.texterra.core.rest.extractors.NLPDocumentOptionsExtractor;
import ru.ispras.texterra.tools.nlp.ITexterraNLP;

@Path(value="")
public class NLPResource {
    private final ITexterraNLP nlp;

    public NLPResource(ITexterraNLP nlp) {
        this.nlp = nlp;
    }

    @GET
    public String printUsage() {
        return "Please choose pipeline.";
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<? extends INLPDocument> nlpBatch(INLPDocument[] docs, @Context UriInfo request, @QueryParam(value="targetType") List<Class<? extends IAnnotation>> targetTypes, @QueryParam(value="inputType") List<Class<? extends IAnnotation>> inputTypes) {
        return this.nlp.traverse(Arrays.asList(docs), this.createSpec(request, targetTypes, inputTypes));
    }

    private ITexterraNLP.PipelineSpecification createSpec(UriInfo request, List<Class<? extends IAnnotation>> targetTypes, List<Class<? extends IAnnotation>> inputTypes) {
        ITexterraNLP.PipelineSpecification spec = new ITexterraNLP.PipelineSpecification().withTargets(targetTypes).withInputs(inputTypes);
        return spec.withKnownOptions(new NLPDocumentOptionsExtractor().apply((MultivaluedMap<String, String>)request.getQueryParameters()));
    }

    @POST
    @Produces(value={"application/xml; q=2", "application/json"})
    @Path(value="{pipeline:.+}")
    public INLPDocument pipeline(@PathParam(value="pipeline") ITexterraNLP.PipelineSpecification pipelineSpec, @FormParam(value="text") String text, @QueryParam(value="filtering") @DefaultValue(value="NO_FILTERING") NLPDocumentFilteringUtils.FilteringOptions filtering, @QueryParam(value="class") List<Class<? extends IAnnotation>> classes) {
        return new PipelineProcessor(pipelineSpec, new FilteringOptions(filtering, classes), this.nlp).process(text);
    }
}

