/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.extractors;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Function;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import ru.ispras.texterra.core.common.concept.Domain;
import ru.ispras.texterra.core.nlp.datamodel.DomainAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.IsTweet;
import ru.ispras.texterra.core.nlp.datamodel.Language;
import ru.ispras.texterra.core.rest.ErrorInfo;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.utils.language.ITexterraLanguage;
import ru.ispras.texterra.utils.language.TexterraLanguageException;
import ru.ispras.texterra.utils.language.TexterraLanguagesManager;

public final class NLPDocumentOptionsExtractor
implements Function<MultivaluedMap<String, String>, NLPDocumentOptions> {
    private static final Set<String> tweetCodes = ImmutableSet.of((Object)"true", (Object)"1");

    @Override
    public NLPDocumentOptions apply(MultivaluedMap<String, String> params) {
        String isTweet;
        String domain;
        NLPDocumentOptions opts = new NLPDocumentOptions();
        String language = (String)params.getFirst((Object)"language");
        if (language != null) {
            opts = opts.withOption(Language.class, (Object)this.extractLanguage(language));
        }
        if ((domain = (String)params.getFirst((Object)"domain")) != null) {
            opts = opts.withOption(DomainAnnotation.class, (Object)new Domain(domain));
        }
        if ((isTweet = (String)params.getFirst((Object)"tweet")) != null) {
            opts = opts.withOption(IsTweet.class, (Object)this.extractTweet(isTweet));
        }
        return opts;
    }

    private ITexterraLanguage extractLanguage(String language) {
        try {
            return TexterraLanguagesManager.getTexterraLanguage((String)language);
        }
        catch (TexterraLanguageException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorInfo(String.format("'%s' is not a valid language code.", language))).build());
        }
    }

    private boolean extractTweet(String tweet) {
        return tweetCodes.contains(tweet);
    }
}

